//#######################################################################
// MENUITEM.CPP : Pop-up menu item related function
//
// S_PresetSave()		: Save preset point related data into EEProm.
// S_CallPresetDlg()	: Call preset parameter dialog
//#######################################################################

#include "stdafx.h"
#include "Define.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "misc.h"
#include "comm.h"
#include "Preset.h"
#include "Sequence.h"
#include "Cruise.h"
#include "PresetRenameDlg.h"
#include "DomeRenameDlg.h"
#include "GlobalVar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//######################################################################
// S_SetCom1()
// S_SetCom2()
// S_SetCom3()
// S_SetCom4()
//######################################################################
void CSpeedDomeApp::S_SetCom1()		{	S_SetCom("COM1");	}
void CSpeedDomeApp::S_SetCom2()		{	S_SetCom("COM2");	}
void CSpeedDomeApp::S_SetCom3()		{	S_SetCom("COM3");	}
void CSpeedDomeApp::S_SetCom4()		{	S_SetCom("COM4");	}

//######################################################################
// S_SequenceDlgEE()		Create Sequence Dialog and read data from EE
// S_SequenceDlgFiles()		Create Sequence Dialog and read data from Files
//######################################################################
void CSpeedDomeApp::S_SequenceDlgEE()		{	CSequence::S_CreateSequenceDlg(0);	}
void CSpeedDomeApp::S_SequenceDlgFiles()	{	CSequence::S_CreateSequenceDlg(1);	}

//######################################################################
// S_PresetDlgEE()
// S_PresetDlgFiles()
//######################################################################
void CSpeedDomeApp::S_PresetDlgEE()			
{	CPreset::S_CreatePresetDlg(0);		}
void CSpeedDomeApp::S_PresetDlgFiles()		
{	CPreset::S_CreatePresetDlg(1);		}

//######################################################################
// S_PresetClearEE()		
//######################################################################
void CSpeedDomeApp::S_PresetClearEE()		
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[6]={'\xff','\xff','\xff','\xff','\xff','\xff'};
char			Packet[6]={'\x0','\x0','\x1d','\x01','\x0','\x0'};
UINT			PresetNum;

Flag_Polling=0;
Sleep(100);

//----- Get Preset Number -----------
LPTSTR	PresetBitmapName;
PresetNum=CPreset::S_PresetIDToNum(G_RCtrlID,&PresetBitmapName);

Packet[0]=(char)G_DomeID;
Packet[3]='\x1';
Packet[4]=PresetNum-1;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];
CComm::RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

Flag_Polling=1;
}
//#######################################################################
// S_PresetClearAll()
//#######################################################################
void CSpeedDomeApp::S_PresetClearAll()		
{	
S_PresetClearEE();
CPreset::S_PresetClearFile();		
}

//#######################################################################
// S_PresetSaveEE : 
//#######################################################################
void CSpeedDomeApp::S_PresetSaveEE()	
{	
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[6]={'\xff','\xff','\xff','\xff','\xff','\xff'};
char			Packet[6]={'\x0','\x0','\x1d','\x0','\x0','\x0'};
UINT			PresetNum;

//----- Get Preset Number -----------
Flag_Polling=0;
Sleep(100);
LPTSTR	PresetBitmapName;
PresetNum=CPreset::S_PresetIDToNum(G_RCtrlID,&PresetBitmapName);

Packet[0]=(char)G_DomeID;
Packet[3]='\x0';
Packet[4]=PresetNum-1;

Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];
CComm::RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
	
Flag_Polling=1;
}

//###################################################################
// S_PresetSaveAll :	
//#######################################################################
void CSpeedDomeApp::S_PresetSaveAll()	
{	
S_PresetSaveEE();
S_PresetSaveFile();
}


//#######################################################################
// S_PresetSave : 
//
// Save preset point related data into EEProm.
//#######################################################################
void CSpeedDomeApp::S_PresetSaveFile()
{
DWORD	NumberOfBytesWritten,NumberOfBytesRead;
char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char	R_PanPkt[6]={'\x0','\x0','\x09','\x0','\x0','\x0'};
char	R_TiltPkt[6]={'\x0','\x0','\x0a','\x0','\x0','\x0'};
char	R_ZoomPkt[6]={'\x0','\x0','\x20','\x01','\x0','\x0'};
char	R_FocusPkt[6]={'\x0','\x0','\x20','\x02','\x0','\x0'};
char	R_RPkt[6]={'\x0','\x0','\x2b','\x0','\x0','\x0'};
char	Para[10]="\x14\x00\x00\x00\x00\x00\xff\x18\x12";
char	EEAddr[3];
UINT	PresetNum;
WORD	Y_Addr;

R_PanPkt[0]=(char)G_DomeID;
R_TiltPkt[0]=(char)G_DomeID;
R_ZoomPkt[0]=(char)G_DomeID;
R_FocusPkt[0]=(char)G_DomeID;
R_RPkt[0]=(char)G_DomeID;

R_PanPkt[5]=(((R_PanPkt[0]^R_PanPkt[1])^R_PanPkt[2] )^R_PanPkt[3])^R_PanPkt[4];
R_TiltPkt[5]=(((R_TiltPkt[0]^R_TiltPkt[1])^R_TiltPkt[2] )^R_TiltPkt[3])^R_TiltPkt[4];
R_ZoomPkt[5]=(((R_ZoomPkt[0]^R_ZoomPkt[1])^R_ZoomPkt[2] )^R_ZoomPkt[3])^R_ZoomPkt[4];
R_FocusPkt[5]=(((R_FocusPkt[0]^R_FocusPkt[1])^R_FocusPkt[2] )^R_FocusPkt[3])^R_FocusPkt[4];
R_RPkt[5]=(((R_RPkt[0]^R_RPkt[1])^R_RPkt[2] )^R_RPkt[3])^R_RPkt[4];
//---- Request Pan location -------------------------------------------
CComm::RTS_WriteReadFile(hcom,R_PanPkt,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
Para[0]=Buffer[3];		Para[1]=Buffer[4];
//---- Request Tilt location ------------------------------------------
CComm::RTS_WriteReadFile(hcom,R_TiltPkt,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);
Para[2]=Buffer[3];		Para[3]=Buffer[4];
//---- Request Zoom and Focus location --------------------------------
//--- Request Zoom ----
CComm::RTS_WriteReadFile(hcom,R_ZoomPkt,6,&NumberOfBytesWritten,NULL,
			  Buffer,&NumberOfBytesRead,G_DelayTime);
CComm::RTS_WriteReadFile(hcom,R_RPkt,6,&NumberOfBytesWritten,NULL,
			  Buffer,&NumberOfBytesRead,G_DelayTime);
Para[4]=Buffer[3];		Para[5]=Buffer[4];
//--- Request Focus ----
CComm::RTS_WriteReadFile(hcom,R_FocusPkt,6,&NumberOfBytesWritten,NULL,
			  Buffer,&NumberOfBytesRead,G_DelayTime);
CComm::RTS_WriteReadFile(hcom,R_RPkt,6,&NumberOfBytesWritten,NULL,
			  Buffer,&NumberOfBytesRead,G_DelayTime);
Para[6]=Buffer[3];		Para[7]=Buffer[4];


//----- Get Preset EE Addr -----------
LPTSTR	PresetBitmapName;
PresetNum=CPreset::S_PresetIDToNum(G_RCtrlID,&PresetBitmapName);
Y_Addr=EE_BASE_PRESET+(PresetNum-1)*EE_SIZE_PRESET;
EEAddr[0]=LOBYTE(Y_Addr);
EEAddr[1]=HIBYTE(Y_Addr);
//------------------------------------
//-- Write File --
CPreset::S_WritePresetParaFile(PresetNum,Para);

}

//######################################################################
// S_CallPresetRename
//######################################################################

void CSpeedDomeApp::S_PresetRenameDlg()
{
CPresetRenameDlg	RenameDlg;

int nResponse = RenameDlg.DoModal();
if (nResponse == IDOK)
	{	}
else if (nResponse == IDCANCEL)
	{	}

}

//######################################################################
// S_CallDomeRename
//######################################################################
void CSpeedDomeApp::S_DomeRenameDlg()
{
CDomeRenameDlg	RenameDlg;

int nResponse = RenameDlg.DoModal();
if (nResponse == IDOK)
	{	}
else if (nResponse == IDCANCEL)
	{	}

}


//######################################################################
// S_CruiseDlg()			Call cruise dialog
//######################################################################
void CSpeedDomeApp::S_CruiseDlg()
{
CCruise::S_CreateCruiseDlg();
}

//######################################################################
// S_WriteCruiseFileToEE()
//######################################################################
void CSpeedDomeApp::S_WriteCruiseFileToEE()
{
LPTSTR		CruiseBmpName;
UINT		CruiseNum;

Flag_Polling=0;
Sleep(100);
CruiseNum=CCruise::S_CruiseIDToNum(G_RCtrlID,&CruiseBmpName);
CCruise::S_Cruise_ReadFileToEE(CruiseNum);
Flag_Polling=1;
}

//######################################################################
// S_SetCom()
//######################################################################

void CSpeedDomeApp::S_SetCom(char *string)
{
FILE			*fstream;
char			Temp[30];
char			LineBuffer[100];
char			RS232_485string[30]={NULL};
char			COMstring[30]={NULL};
unsigned int	AVL_NUM_DOME;

if( (fstream = fopen( "SpeedDome.ini", "r" )) != NULL )
	{
	//--- Scan COM setting ---------------------------------------
	if( fgets( LineBuffer, 80, fstream ) == NULL)		
		AfxMessageBox("Read Communication Port Setting Error\n");
	else						
		sscanf(LineBuffer,"%s = %s",Temp,COMstring);
	//--- Scan Devices setting -----------------------------------
	if( fgets( LineBuffer, 80, fstream ) == NULL)		
		AfxMessageBox("Read Devices Number Error\n");
	else						
		sscanf(LineBuffer,"%s = %u ",Temp,&AVL_NUM_DOME);
	//--- Scan RS232-485 setting ----------------------------------
	if( fgets( LineBuffer, 80, fstream ) == NULL)		
		AfxMessageBox("Read RS232-485 Setting Error\n");
	else						
		sscanf(LineBuffer,"%s = %s ",Temp,RS232_485string);
	fclose( fstream );
	}

if( (fstream = fopen( "SpeedDome.ini", "w" )) != NULL )
	{
	fprintf(fstream,"COM		=	%s \n",string);
	fprintf(fstream,"DEVICES    =	%u \n",AVL_NUM_DOME);
	fprintf(fstream,"RS232-485	=	%s \n",RS232_485string);
	fclose( fstream );
	}
}